﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{


    [DataObjectAttribute()]
    public static class OrdersDetailsBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static OrdersDetails GetItem(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            return OrdersDetailsDB.GetItem(ordersDetailsID, ordersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<OrdersDetails> GetList(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            return OrdersDetailsDB.GetList(ordersDetailsID, ordersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            return OrdersDetailsDB.GetDataTable(ordersDetailsID, ordersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            return OrdersDetailsDB.GetDataSet(ordersDetailsID, ordersID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(OrdersDetails myOrdersDetails)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                OrdersDetailsDB.Save(myOrdersDetails);
                myTransactionScope.Complete();
                return true;
            }
        }
        [DataObjectMethod(DataObjectMethodType.Delete, true)]
        public static bool Delete()
        {
            OrdersDetailsDB.Delete();
            return true;
        }

        [DataObjectMethod(DataObjectMethodType.Select, true)]
        public static string GetNewDONumber(Guid ordersID, Guid ordersDetailsID, string invoiceNo)
        {
            return OrdersDetailsDB.GetNewDONumber(ordersID, ordersDetailsID, invoiceNo);
        }
    }
}
